<?php

/**
 * i-doit
 *
 * Extracted from isys_jdisc_dao_discovery to isys_jdisc_dao_discovery_soap
 *
 * @deprecated  Please use isys_jdisc_dao_discovery_graphql
 * @package     i-doit
 * @subpackage  Modules
 * @author      Van Quyen Hoang <qhoang@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.5
 */
class isys_jdisc_dao_discovery_soap extends isys_jdisc_dao_discovery
{
    /**
     * JDisc Connection Session ID
     *
     * @var array
     */
    protected $m_sessionID = null;

    /**
     * Function for disconnecting from the Host
     *
     * @return $this
     * @throws Exception
     * @throws isys_exception_general
     */
    public function disconnect()
    {
        global $g_dirs;
        $l_wsdl_dir = $g_dirs['class'] . 'modules/synetics_jdisc/soap/';

        try {
            if (file_exists($l_wsdl_dir . 'LogonService.wsdl')) {
                $this->m_soap_connector->set_wsdl($l_wsdl_dir . 'LogonService.wsdl')
                    ->set_base_url('/InventoryLogon');
                $l_options = $this->m_soap_request_options;
                $l_options['args'] = [
                    'parameters' => [
                        'session' => $this->get_sessionID()
                    ]
                ];
                $this->m_soap_connector->request('logoff', $l_options);
            } else {
                throw new Exception('WSDL file soap/LogonService.wsdl does not exist in module folder.');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        return $this;
    }

    /**
     * Method to connect to the Host via SOAP
     *
     * @param        $p_host
     * @param        $p_username
     * @param        $p_password
     * @param string $p_port
     * @param string $p_protocol
     *
     * @return $this
     * @throws Exception
     * @throws isys_exception_general
     */
    public function connect($p_host, $p_username, $p_password, $p_port = '9000', $p_protocol = 'http')
    {
        global $g_dirs;
        $l_wsdl_dir = $g_dirs['class'] . 'modules/synetics_jdisc/soap/';

        try {
            if (file_exists($l_wsdl_dir . 'LogonService.wsdl')) {
                if (!$this->m_soap_connector) {
                    $this->m_soap_connector = isys_protocol_soap::get_instance($p_host, $p_port, $p_protocol);
                    $this->m_soap_request_options = [
                        'soap_version' => SOAP_1_2,
                        'uri'          => $p_protocol . '//' . $p_host
                    ];
                }
                $this->m_soap_connector->set_wsdl($l_wsdl_dir . 'LogonService.wsdl')
                    ->set_base_url('/InventoryLogon')
                    ->set_user($p_username)
                    ->set_pass($p_password);
                $l_options = $this->m_soap_request_options;
                $l_options['args'] = [
                    'parameters' => [
                        'username' => $p_username,
                        'password' => $p_password
                    ]
                ];
                $l_session_data = $this->m_soap_connector->request('logon', $l_options);
                if ($l_session_data->logonResult->status === "Success") {
                    $this->set_sessionID((array)$l_session_data->logonResult->sessionId);
                } else {
                    throw new Exception('Credentials for the discovery webservice are not valid.');
                }
            } else {
                throw new Exception('WSDL file soap/LogonService.wsdl does not exist in module folder.');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        return $this;
    }

    /**
     * Gets all discovery jobs as html options
     *
     * @deprecated use src/classes/modules/synetics_jdisc/src/Graphql/Query/Job/GetJobs.php instead
     *
     * @throws Exception
     */
    public function get_discovery_jobs()
    {
        global $g_dirs;
        $l_return = [];

        try {
            $l_wsdl_dir = $g_dirs['class'] . 'modules/synetics_jdisc/soap/';

            if (file_exists($l_wsdl_dir . 'DiscoveryService.wsdl')) {
                if ($this->m_soap_connector) {
                    $this->m_soap_connector->set_wsdl($l_wsdl_dir . 'DiscoveryService.wsdl')
                        ->set_base_url('/Discovery');
                    $l_options = $this->m_soap_request_options;
                    $l_options['args'] = [
                        'parameters' => [
                            'sessionId' => $this->get_sessionID()
                        ]
                    ];
                    $l_jobs_data = $this->m_soap_connector->request('getDiscoveryJobs', $l_options);
                    $l_jobs_arr = (array)$l_jobs_data->discoveryJobsResult->jobs;
                    if (isset($l_jobs_arr[1])) {
                        foreach ($l_jobs_arr as $l_obj) {
                            $l_return[] = (array)$l_obj;
                        }
                    } else {
                        $l_return[] = $l_jobs_arr;
                    }
                }
            } else {
                throw new Exception('WSDL file soap/DiscoveryService.wsdl does not exist in module folder.');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        return $l_return;
    }

    /**
     * Method for starting a discovery job
     *
     * @deprecated use src/classes/modules/synetics_jdisc/src/Graphql/Mutation/Discovery/StartJob.php
     *
     * @return bool
     * @throws Exception
     * @throws isys_exception_general
     */
    public function start_discovery_job()
    {
        global $g_dirs;
        $l_status = 'Failure';

        try {
            $l_wsdl_dir = $g_dirs['class'] . 'modules/synetics_jdisc/soap/';

            if (file_exists($l_wsdl_dir . 'DiscoveryService.wsdl')) {
                if ($this->m_soap_connector) {
                    $this->m_soap_connector->set_wsdl($l_wsdl_dir . 'DiscoveryService.wsdl')
                        ->set_base_url('/Discovery');
                    $l_options = $this->m_soap_request_options;
                    $l_options['args'] = [
                        'parameters' => [
                            'sessionId'    => $this->get_sessionID(),
                            'discoveryJob' => $this->get_discovery_job()
                        ]
                    ];
                    $l_status_data = $this->m_soap_connector->request('startDiscoveryJob', $l_options);
                    $l_status = $l_status_data->status;
                }
            } else {
                throw new Exception('WSDL file soap/DiscoveryService.wsdl does not exist in module folder.');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        switch ($l_status) {
            case 'Success':
                return true;
                break;
            case 'Failure':
            default:
                return false;
                break;
        }
    }

    /**
     * Method to trigger a discovery to the specified target device
     *
     * @deprecated use instead src/classes/modules/synetics_jdisc/src/Graphql/Mutation/Discovery/DiscoverDevice.php
     *
     * @return bool
     * @throws Exception
     */
    public function discover_device()
    {
        if ($this->get_target() === null) {
            return false;
        }

        global $g_dirs;
        $l_status = 'Failure';

        try {
            $l_wsdl_dir = $g_dirs['class'] . 'modules/synetics_jdisc/soap/';

            if (file_exists($l_wsdl_dir . 'DiscoveryService.wsdl')) {
                if ($this->m_soap_connector) {
                    $this->m_soap_connector->set_wsdl($l_wsdl_dir . 'DiscoveryService.wsdl')
                        ->set_base_url('/Discovery');
                    $l_options = $this->m_soap_request_options;
                    $l_options['args'] = [
                        'parameters' => [
                            'sessionId' => $this->get_sessionID(),
                            'target'    => $this->get_target()
                        ]
                    ];
                    $l_status_data = $this->m_soap_connector->request('discoverDevice', $l_options);
                    $l_status = $l_status_data->status;
                }
            } else {
                throw new Exception('WSDL file soap/DiscoveryService.wsdl does not exist in module folder.');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        switch ($l_status) {
            case 'Success':
                return true;
                break;
            case 'Failure':
            default:
                return false;
                break;
        }
    }

    /**
     * Get current running discovery log
     *
     * @return array|bool
     * @throws Exception
     *
     * @deprecated use instead src/classes/modules/synetics_jdisc/src/Graphql/Query/GetDiscoveryLog.php
     *
     */
    public function get_running_discover_status()
    {
        global $g_dirs;

        try {
            $l_wsdl_dir = $g_dirs['class'] . 'modules/synetics_jdisc/soap/';

            if (file_exists($l_wsdl_dir . 'DiscoveryService.wsdl')) {
                if ($this->m_soap_connector) {
                    $this->m_soap_connector->set_wsdl($l_wsdl_dir . 'DiscoveryService.wsdl')
                        ->set_base_url('/Discovery');
                    $l_options = $this->m_soap_request_options;
                    $l_status_data = $this->m_soap_connector->request('getStatus', $l_options);
                    $l_status = $l_status_data->discoveryStatus->discoveryStatus;
                    $l_log = $l_status_data->discoveryStatus->discoveryStatusMessage;

                    return [
                        'status' => $l_status,
                        'log'    => $l_log
                    ];
                }
            } else {
                throw new Exception('WSDL file soap/DiscoveryService.wsdl does not exist in module folder.');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        return false;
    }

    /**
     * Getter for the JDisc session id
     *
     * @return array
     */
    public function get_sessionID()
    {
        return $this->m_sessionID;
    }

    /**
     * Setter for the JDisc session id
     *
     * @param $p_session
     *
     * @return $this
     */
    public function set_sessionID($p_session)
    {
        $this->m_sessionID = $p_session;

        return $this;
    }

    /**
     * @throws isys_exception_general
     */
    public function __destruct()
    {
        if ($this->m_sessionID) {
            $this->disconnect();
        }
    }
}
