<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsJdisc\Controller\Table;

use idoit\Module\SyneticsJdisc\Enum\SyncStatus;
use Idoit\Dto\Serialization\Serializer;
use Throwable;

class DeviceListSearchParams extends SearchParams
{
    public function __construct(
        int $page = 0,
        int $perPage = 100,
       ?Sort $sort = null,
        private bool $ignoreCase = false,
        private bool $invertSearch = false,
        private SyncStatus $syncStatus = SyncStatus::ANY,
    )
    {
        parent::__construct($page, $perPage, $sort);
    }

    public function isIgnoreCase(): bool
    {
        return $this->ignoreCase;
    }

    public function isInvertSearch(): bool
    {
        return $this->invertSearch;
    }

    public function getSyncStatus(): SyncStatus
    {
        return $this->syncStatus;
    }

    public static function fromParams(?string $params): self
    {
        $result = new DeviceListSearchParams();
        try {
            $data = json_decode($params, true);
            if (isset($data['syncStatus'])) {
                $data['syncStatus'] = SyncStatus::from($data['syncStatus']);
            }

            $result = Serializer::fromJson(DeviceListSearchParams::class, $data);
        } catch (Throwable) {
            // fallback
        }
        return $result;
    }
}
