<?php

namespace idoit\Module\SyneticsJdisc\Graphql\Query;

use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\SyneticsJdisc\Graphql\AbstractGraphql;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;

// example:
//
// $connector = Connector::instance($serverId);
// $connector->connect();
// $query = new GetDevice();
// $query->setId(100);
// $data = $connector->query($query);

class GetDevice extends AbstractGraphql implements ResponseInterface
{
    private int $id;

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return array
     */
    public function getParameters(): array
    {
        return [];
    }

    /**
     * @return array
     */
    public function getSelections(): array
    {
        return [];
    }


    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return $data['devices']['findByID'] ?? [];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Query())->setSelectionSet([
            (new Query('devices'))->setSelectionSet([
                (new Query('findByID'))
                    ->setArguments([
                        'id' => $this->getId(),
                    ])
                    ->setSelectionSet([
                        'id',
                        'name',
                        'mainIPAddress',
                        'manufacturer',
                        'model',
                        'type',
                        (new Query('operatingSystem'))
                            ->setSelectionSet([
                                'osVersion',
                                'patchLevel',
                            ]),
                        (new Query('bios'))
                            ->setSelectionSet([
                                'version',
                            ]),
                        'serialNumber',
                        'creationTime',
                        'discoveryTime',
                        'lastSeenTime',
                    ])
            ]),
        ]);
    }
}
