<?php
namespace idoit\Module\SyneticsJdisc\Graphql\Query\Job;

use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\SyneticsJdisc\Graphql\AbstractGraphql;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;
use idoit\Module\SyneticsJdisc\Graphql\Type\AbstractType;

class GetJobs extends AbstractGraphql implements ResponseInterface
{
    /**
     * @return array|AbstractType[]
     */
    public function getParameters(): array
    {
        return [];
    }

    /**
     * @return string[]
     */
    public function getSelections(): array
    {
        return [
            'id',
            'name',
            'description'
        ];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Query('discovery'))
            ->setSelectionSet([
                (new Query('discoveryJobs'))
                    ->setSelectionSet([
                        (new Query('findAll'))
                            ->setSelectionSet($this->getSelections())
                    ])
            ]);
    }

    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return $data['discovery']['discoveryJobs']['findAll'];
    }
}
