<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type AccountDataInput
 * An account object containing account data for various account types * @property null|AceBITPasswordDepotSecretInputInputType $acebitPasswordDepotServerAccount = null The AceBIT Password Depot secret server account
 * @property null|string $comment = null The account's comment string.
 * @property null|CyberarkAccountInputInputType $cyberarkAccount = null The cyberark secret server account
 * @property mixed $id = null The account's id.
 * @property null|bool $isLaps = null The laps flag
 * @property null|ManageEnginePMPAccountInputInputType $manageEnginePMPAccount = null The manageEnginePMP secret server account
 * @property null|string $password = null The account's password.
 * @property null|PasswordstateAccountInputInputType $passwordstateAccount = null The passwordstate secret server account
 * @property null|string $snmpCommunity = null The snmp account's read community.
 * @property null|string $snmpV3AuthPassword = null The snmp v3 account's password.
 * @property null|SnmpV3AuthProtocolEnum $snmpV3AuthProtocol = null The snmp v3 account's authentication protocol.
 * @property null|string $snmpV3AuthUser = null The snmp v3 account's login name.
 * @property null|string $snmpV3PrivacyPassword = null The snmp v3 account's encryption password.
 * @property null|SnmpV3PrivProtocolEnum $snmpV3PrivacyProtocol = null The snmp v3 account's privacy/encryption protocol.
 * @property null|AccountTypeEnum $sshAccountType = null The SSH key account type.
 * @property null|SshPublicPrivateKeyDataInputInputType $sshKey = null The SSH Key.
 * @property null|ThycoticSecretServerAccountInputInputType $thycoticSecretServerAccount = null The thycotic secret server account
 * @property null|AccountTypeEnum $type = null The account's username.
 * @property null|string $username = null The account's username.
 */
final class AccountDataInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'acebitPasswordDepotServerAccount') {
            return new AceBITPasswordDepotSecretInputInputType($value);
        }

        if ($name === 'cyberarkAccount') {
            return new CyberarkAccountInputInputType($value);
        }

        if ($name === 'manageEnginePMPAccount') {
            return new ManageEnginePMPAccountInputInputType($value);
        }

        if ($name === 'passwordstateAccount') {
            return new PasswordstateAccountInputInputType($value);
        }

        if ($name === 'snmpV3AuthProtocol') {
            return new SnmpV3AuthProtocolEnum($value);
        }

        if ($name === 'snmpV3PrivacyProtocol') {
            return new SnmpV3PrivProtocolEnum($value);
        }

        if ($name === 'sshAccountType') {
            return new AccountTypeEnum($value);
        }

        if ($name === 'sshKey') {
            return new SshPublicPrivateKeyDataInputInputType($value);
        }

        if ($name === 'thycoticSecretServerAccount') {
            return new ThycoticSecretServerAccountInputInputType($value);
        }

        if ($name === 'type') {
            return new AccountTypeEnum($value);
        }

        return $value;
    }
}