<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type IntegrationRegistration
 * The integration registration is required when other tools like CMDB solution register as a data importer.

Whenever there is at least one integration registered, JDisc Discovery calculates hash values for
all data categories (such as memory modules, processors etc.). A CMDB integration can then call a method to mark a device as
imported. When a device is marked as imported, it clones the hash values. That enables an easy comparison between the current device data
and the state when it was imported the last time. Devices with no change in their data do not need to be imported again. */
final class IntegrationRegistrationType implements AutoGenerationInterface
{
    /**
     * The name for the integrating application (e.g. the CMDB product name)
     */
    public ?string $applicationName = null;
    /**
     * Finds all device summaries for this integration
     * @var null|iterable
     */
    public ?iterable $comparisonSummaries = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The instance name (in case there are multiple instances for an integrated product
     */
    public ?string $instanceName = null;
    /**
     * The unique id. External tools should refer to the integration only by their unique id
     */
    public ?string $uniqueId = null;
}