<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type KubernetesReplicaSetInput
 * A kubernetes replica set. * @property null|ClusterInputInputType $cluster = null The cluster that this replicaset is assigned to.
 * @property mixed $createdAt = null The timestamp when this replica set was created.
 * @property null|string $name = null The kubernetes replica set name.
 * @property null|KubernetesNamespaceInputInputType $namespace = null The namespace that this replica set is assigned to.
 * @property null|iterable|DeviceInputInputType[] $pods = null The pods associated with this replicaset.
 * @property null|iterable|DeviceInputInputType[] $services = null The pods associated with this replicaset.
 * @property null|string $uniqueId = null A kubernetes replica set's unique id.
 */
final class KubernetesReplicaSetInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'cluster') {
            return new ClusterInputInputType($value);
        }

        if ($name === 'namespace') {
            return new KubernetesNamespaceInputInputType($value);
        }

        if ($name === 'pods') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'services') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        return $value;
    }
}