<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type LoggedOnUserInput
 * A logged-on user on an operating system * @property null|DiscoveredUserTypeEnum $discoveredUserType = null The user type
 * @property mixed $lastLogin = null The user last login
 * @property mixed $loginCount = null The number of times a user has been found logged on while scanning the device
 * @property null|OperatingSystemInputInputType $operatingSystem = null The operating system that the user belongs to
 * @property null|DeviceInputInputType $remoteClientDevice = null Remote device that this user connects from
 * @property null|UserInputInputType $user = null The associated logged-on user
 * @property null|DiscoveredUserRoleEnum $role = null The associated role of the user
 */
final class LoggedOnUserInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'discoveredUserType') {
            return new DiscoveredUserTypeEnum($value);
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        if ($name === 'remoteClientDevice') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'user') {
            return new UserInputInputType($value);
        }

        if ($name === 'role') {
            return new DiscoveredUserRoleEnum($value);
        }

        return $value;
    }
}