<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Processor
 * The processor represents a processor within a processor slot on the mainboard. */
final class ProcessorType implements AutoGenerationInterface
{
    /**
     * The processor's address width.
     */
    public ?int $addressWidth = null;
    /**
     * The current clock speed at the time of the scan in Mhz
     */
    public ?int $currentClockSpeed = null;
    /**
     * The processor's data width.
     */
    public ?int $dataWidth = null;
    /**
     * The processor's device id.
     */
    public ?string $devID = null;
    /**
     * A flag whether hyperthreading is enabled or not
     */
    public ?bool $htEnabled = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The processor's level 2 cache size.
     */
    public ?int $l2CacheSize = null;
    /**
     * The processor's level 2 cache speed.
     */
    public ?int $l2CacheSpeed = null;
    /**
     * The processor's level 3 cache size.
     */
    public ?int $l3CacheSize = null;
    /**
     * The processor's level 3 cache speed.
     */
    public ?int $l3CacheSpeed = null;
    /**
     * The processor's manufacturer.
     */
    public ?string $manufacturer = null;
    /**
     * The maximal clock speed at the time of the scan in Mhz
     */
    public ?int $maxClockSpeed = null;
    /**
     * The processor's model.
     */
    public ?string $model = null;
    /**
     * The number of cores.
     */
    public ?int $numberOfCores = null;
    /**
     * The number of efficiency cores.
     */
    public ?int $numberOfECores = null;
    /**
     * The number of enabled cores. Some servers allow to disable cores.
For instance to be license compliant for software that is licensed per core.
     */
    public ?int $numberOfEnabledCores = null;
    /**
     * The number of performance cores.
     */
    public ?int $numberOfPCores = null;
    /**
     * The number of threads.
     */
    public ?int $numberOfThreads = null;
    /**
     * The processor's raw model as it comes from the BIOS information.
     */
    public ?string $rawModel = null;
    /**
     * The processor's status
     */
    public ?ProcessorStatusEnum $status = null;
}