<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsJdisc\Model\Dto;

use JsonSerializable;
use Idoit\Dto\Serialization\SerializableTrait;

class ConfServer implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private int $id,
        private int $group_id,
        private ?array $filter,
        private int $import_mode,
        private int $logging,
        private int $overwrite_ip,
        private int $search_index
    ) {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getGroupId(): int
    {
        return $this->group_id;
    }

    public function getFilter(): ?array
    {
        return $this->filter;
    }

    public function getImportMode(): int
    {
        return $this->import_mode;
    }

    public function getLogging(): int
    {
        return $this->logging;
    }

    public function getOverwriteIp(): int
    {
        return $this->overwrite_ip;
    }

    public function getSearchIndex(): int
    {
        return $this->search_index;
    }
}