<?php

namespace idoit\Module\SyneticsJdisc\Model\Dto;

use DateTime;

class LogDto
{
    public const STATUS_SUCCESS = 1;
    public const STATUS_FAILURE = 0;

    private function __construct(
        private int $serverId,
        private int $profileId,
        private DateTime $startDate
    ) {
    }

    public static function factory(int $serverId, int $profileId): LogDto
    {
        return new self($serverId, $profileId, new DateTime());
    }

    public function getServerId(): int
    {
        return $this->serverId;
    }

    public function getProfileId(): int
    {
        return $this->profileId;
    }

    public function getStartDate(): DateTime
    {
        return $this->startDate;
    }

    /**
     * @return string
     */
    public function getFullFileName(): string
    {
        return $this->getFilePath() . $this->getFileName();
    }

    public function getFilePath(): string
    {
        return BASE_DIR . "/log/jdisc/{$this->serverId}/{$this->profileId}/";
    }

    public function getFileName(): string
    {
        return $this->startDate->format('Y-m-d_H-i-s') . '.log';
    }
}
