<style>
    [{include file=$cssPath}]
</style>
<div id="duplicate_popup" class="duplicate-modal">
    <div class="outer-content header">
        <h1>[{$modalTitle}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="content">
        [{if $error}]
        <div id="msgbox_error" class="popup-content p5 bg-red">[{$error}]</div>
        [{else}]
        <table class="contentTable">
            <tbody>
            <tr>
                <td class="key">[{isys type='lang' ident='LC__MODULE__JDISC__ORIGINAL_NAME'}]</td>
                <td class="value pl20">[{isys type='lang' ident='LC__MODULE__JDISC__NEW_NAME'}]</td>
            </tr>
                [{foreach item=item from=$items}]
                <tr>
                    <td class="key">[{isys type='f_label' name=$item.id ident=$item.title}]</td>
                    <td class="value">[{isys type='f_text' name=$item.id p_strValue=$item.title p_strClass="input-small"}]</td>
                </tr>
                [{/foreach}]
            </tbody>
        </table>
        [{/if}]
    </div>

    <div class="outer-content footer">
        [{if !$error}]
        <button type="button" id="save_button" class="btn mr5">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt=""/><span>[{isys type="lang" ident="LC__NAVIGATION__NAVBAR__DUPLICATE"}]</span>
        </button>
        [{/if}]

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt=""/><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const $save_button = $('save_button');
        const $popup = $('duplicate_popup');

        if ($save_button) {
            $save_button.on('click', function () {
                $save_button
                    .disable()
                    .down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif')
                    .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

                $('navMode').setValue('[{$smarty.const.C__NAVMODE__DUPLICATE}]');
                $('isys_form').submit();
            });
        }

        $popup.on('click', '.popup-closer', function () {
            Modal.close($popup.up('.modal'));
        });
    })();
</script>
