<?php

declare (strict_types=1);
namespace Axtiva\FlexibleGraphql\Example\GraphQL\Representation;

use Axtiva\FlexibleGraphql\Example\GraphQL\Model\CodedCurrencyType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\NamedCurrencyType;
use GraphQL\Type\Definition\ResolveInfo;
use Axtiva\FlexibleGraphql\Representation;
use Axtiva\FlexibleGraphql\Resolver\FederationRepresentationResolverInterface;
use Axtiva\FlexibleGraphql\Generator\Exception\NotImplementedResolver;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * Representation resolver for federated graphql type Account
 */
final class AccountRepresentation implements FederationRepresentationResolverInterface
{
    public function getTypeName(): string
    {
        return 'Account';
    }

    public function __invoke(Representation $representation, $context, ResolveInfo $info)
    {
        $model = new \Axtiva\FlexibleGraphql\Example\GraphQL\Model\AccountType();
        $model->id  = $representation->getFields()['id'];
        $model->number = 'fdasf32dsfasge3';

        $namedCurrency = new NamedCurrencyType();
        $namedCurrency->id = '32';
        $namedCurrency->name = 'DemoName';

        $codedCurrency = new CodedCurrencyType(42, 323);
        $codedCurrency->id = '42';
        $codedCurrency->code = 42;

        $model->currency = rand(0,1) ? $namedCurrency : $codedCurrency;
        return $model;
    }
}