<?php

use idoit\Module\SyneticsJdisc\Controller\DeviceListColumnsController;
use idoit\Module\SyneticsJdisc\Controller\DeviceListController;
use idoit\Module\SyneticsJdisc\Controller\DiscoveryController;
use idoit\Module\SyneticsJdisc\Controller\DiscoveryServerController;
use idoit\Module\SyneticsJdisc\Controller\ImportController;
use idoit\Module\SyneticsJdisc\Controller\IndexController;
use idoit\Module\SyneticsJdisc\Controller\LogController;
use idoit\Module\SyneticsJdisc\Controller\LogsController;
use idoit\Module\SyneticsJdisc\Controller\SyncProfileController;
use idoit\Module\SyneticsJdisc\Controller\TokenController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('jdisc.log', '/synetics_jdisc/show-log/{filename}')
        ->methods(['GET'])
        ->requirements(['filename' => '^jdisc-import_\d{4}-\d{2}-\d{2}\.log$'])
        ->controller([LogController::class, 'getLogByFilename']);

    // Index page.
    $routes->add('jdisc.frame-index', '/synetics_jdisc/iframe')
        ->methods(['GET'])
        ->controller([IndexController::class, 'iframe']);

    $routes->add('jdisc.frame-index-with-slug', '/synetics_jdisc/iframe/{slug}')
        ->methods(['GET'])
        ->requirements(['slug' => '.*'])
        ->controller([IndexController::class, 'iframe']);

    // Index page.
    $routes->add('jdisc.index', '/synetics_jdisc')
        ->methods(['GET'])
        ->controller([IndexController::class, 'page']);

    $routes->add('jdisc.index-with-slug', '/synetics_jdisc/{slug}')
        ->methods(['GET'])
        ->requirements(['slug' => '.*'])
        ->controller([IndexController::class, 'page']);

    // Profile api
    $routes->add('jdisc.api.sync-profile.find', '/api/jdisc/sync-profile')
        ->methods(['GET'])
        ->controller([SyncProfileController::class, 'find']);

    $routes->add('jdisc.api.sync-profile.create', '/api/jdisc/sync-profile')
        ->methods(['POST'])
        ->controller([SyncProfileController::class, 'save']);

    $routes->add('jdisc.api.sync-profile.get', '/api/jdisc/sync-profile/{id}')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([SyncProfileController::class, 'get']);

    $routes->add('jdisc.api.sync-profile.delete', '/api/jdisc/sync-profile/{id}')
        ->methods(['DELETE'])
        ->requirements(['id' => '\d+'])
        ->controller([SyncProfileController::class, 'delete']);

    $routes->add('jdisc.api.sync-profile.update', '/api/jdisc/sync-profile/{id}')
        ->methods(['PUT'])
        ->requirements(['id' => '\d+'])
        ->controller([SyncProfileController::class, 'save']);

    $routes->add('jdisc.api.sync-profile.assignments', '/api/jdisc/sync-profile/{id}/assignments')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([SyncProfileController::class, 'getAssignments']);

    $routes->add('jdisc.api.sync-profile.export', '/api/jdisc/sync-profile/export')
        ->methods(['GET'])
        ->controller([SyncProfileController::class, 'export']);

    $routes->add('jdisc.api.sync-profile.form-options', '/api/jdisc/sync-profile/form-options')
        ->methods(['GET'])
        ->controller([SyncProfileController::class, 'getFormOptions']);

    // Server api
    $routes->add('jdisc.api.discovery-server.find', '/api/jdisc/discovery-server')
        ->methods(['GET'])
        ->controller([DiscoveryServerController::class, 'find']);

    $routes->add('jdisc.api.discovery-server.create', '/api/jdisc/discovery-server')
        ->methods(['POST'])
        ->controller([DiscoveryServerController::class, 'save']);

    $routes->add('jdisc.api.discovery-server.get', '/api/jdisc/discovery-server/{id}')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryServerController::class, 'get']);

    $routes->add('jdisc.api.discovery-server.update', '/api/jdisc/discovery-server/{id}')
        ->methods(['PUT'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryServerController::class, 'save']);

    $routes->add('jdisc.api.discovery-server.delete', '/api/jdisc/discovery-server/{id}')
        ->methods(['DELETE'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryServerController::class, 'delete']);

    $routes->add('jdisc.api.discovery-server.check-config', '/api/jdisc/discovery-server/{id}/check-config')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryServerController::class, 'checkConfig']);

    $routes->add('jdisc.api.discovery-server.check-discovery', '/api/jdisc/discovery-server/{id}/check-discovery')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryServerController::class, 'checkDiscovery']);

    $routes->add('jdisc.api.discovery-server.check-graphql', '/api/jdisc/discovery-server/{id}/check-graphql')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryServerController::class, 'checkGraphql']);

    $routes->add('jdisc.api.discovery-server.check-certificate', '/api/jdisc/discovery-server/{id}/check-certificate')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryServerController::class, 'checkCertificate']);

    // Token api (required for device iframe communication)
    $routes->add('disc.api.discovery-server.token', '/api/jdisc/discovery-server/{id}/token')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([TokenController::class, 'get']);

    // Logs api
    $routes->add('jdisc.api.logs.find', '/api/jdisc/logs')
        ->methods(['GET'])
        ->controller([LogsController::class, 'find']);

    $routes->add('jdisc.api.logs.create', '/api/jdisc/logs')
        ->methods(['POST'])
        ->controller([LogsController::class, 'save']);

    $routes->add('jdisc.api.logs.get', '/api/jdisc/logs/{id}')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([LogsController::class, 'get']);

    $routes->add('jdisc.api.logs.delete', '/api/jdisc/logs/{id}')
        ->methods(['DELETE'])
        ->requirements(['id' => '\d+'])
        ->controller([LogsController::class, 'delete']);

    $routes->add('jdisc.api.logs.download', '/api/jdisc/logs/{id}/download')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([LogsController::class, 'download']);

    // Logs page.
    $routes->add('jdisc.logs.index', '/synetics_jdisc/logs')
        ->methods(['GET'])
        ->controller([LogsController::class, 'page']);

    // Discovery api
    $routes->add('jdisc.api.discovery.list', '/api/jdisc/discovery/job')
        ->methods(['GET'])
        ->controller([DiscoveryController::class, 'find']);

    $routes->add('jdisc.api.discovery.status', '/api/jdisc/discovery/status')
        ->methods(['GET'])
        ->controller([DiscoveryController::class, 'getStatus']);

    $routes->add('jdisc.api.discovery.trigger-all', '/api/jdisc/discovery/job')
        ->methods(['PUT'])
        ->controller([DiscoveryController::class, 'triggerAll']);

    $routes->add('jdisc.api.discovery.stop-all', '/api/jdisc/discovery/job/stop')
        ->methods(['PUT'])
        ->controller([DiscoveryController::class, 'stopAll']);

    $routes->add('jdisc.api.discovery.trigger', '/api/jdisc/discovery/job/{id}')
        ->methods(['PUT'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryController::class, 'trigger']);

    $routes->add('jdisc.api.discovery.stop', '/api/jdisc/discovery/job/{id}/stop')
        ->methods(['PUT'])
        ->requirements(['id' => '\d+'])
        ->controller([DiscoveryController::class, 'stop']);

    $routes->add('jdisc.api.discovery.device', '/api/jdisc/discovery/device')
        ->methods(['PUT'])
        ->controller([DiscoveryController::class, 'discoverDevice']);

    // Device list api
    $routes->add('jdisc.api.device-list.find', '/api/jdisc/device-list')
        ->methods(['GET'])
        ->controller([DeviceListController::class, 'find']);

    $routes->add('jdisc.api.device-list.get', '/api/jdisc/device-list/{id}')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([DeviceListController::class, 'get']);

    $routes->add('jdisc.api.device-list.delete', '/api/jdisc/device-list/{id}')
        ->methods(['DELETE'])
        ->requirements(['id' => '\d+'])
        ->controller([DeviceListController::class, 'delete']);

    $routes->add('jdisc.api.device-list.columns.get', '/api/jdisc/device-list/columns')
        ->methods(['GET'])
        ->controller([DeviceListColumnsController::class, 'get']);

    $routes->add('jdisc.api.device-list.columns.hide', '/api/jdisc/device-list/columns/hide')
        ->methods(['PUT'])
        ->controller([DeviceListColumnsController::class, 'hide']);

    // Sync api
    $routes->add('jdisc.api.sync/statistics', '/api/jdisc/sync/statistics')
        ->methods(['GET'])
        ->controller([ImportController::class, 'statistics']);

    $routes->add('jdisc.api.sync/settings', '/api/jdisc/sync/settings')
        ->methods(['GET'])
        ->controller([ImportController::class, 'settings']);

    $routes->add('jdisc.api.device-list.idoit-types', '/api/jdisc/device-list/idoit-types')
        ->methods(['GET'])
        ->controller([DeviceListController::class, 'getIdoitTypes']);
};
