<?php

namespace idoit\Module\SyneticsJdisc\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * JDisc relevant log controller.
 *
 * @package   Modules
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class LogController
{
    /**
     * @param Request $request
     * @param string  $filename
     *
     * @return Response
     */
    public function getLogByFilename(Request $request, string $filename): Response
    {
        $filePath = BASE_DIR . '/log/' . $filename;
        if (!file_exists($filePath)) {
            return new Response(
                'The requested file could not be found!',
                Response::HTTP_NOT_FOUND
            );
        }

        return new Response(
            file_get_contents($filePath),
            Response::HTTP_OK,
            ['content-type' => 'text/plain']
        );
    }
}
