<?php

namespace idoit\Module\SyneticsJdisc\Graphql\Mutation\Authentication;

use GraphQL\Mutation;
use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\SyneticsJdisc\Graphql\AbstractGraphql;
use idoit\Module\SyneticsJdisc\Graphql\ParameterBagInterface;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;
use idoit\Module\SyneticsJdisc\Graphql\Type\AbstractType;
use idoit\Module\SyneticsJdisc\Graphql\Type\StringType;

class Login extends AbstractGraphql implements ParameterBagInterface, ResponseInterface
{
    /**
     * @var StringType
     */
    private StringType $login;

    /**
     * @var StringType
     */
    private StringType $password;

    /**
     * @param StringType $login
     *
     * @return void
     */
    protected function setLogin(StringType $login): void
    {
        $this->login = $login;
    }

    /**
     * @param StringType $password
     *
     * @return void
     */
    protected function setPassword(StringType $password): void
    {
        $this->password = $password;
    }

    /**
     * @return array|AbstractType[]
     */
    public function getParameters(): array
    {
        return [
            $this->login,
            $this->password
        ];
    }

    /**
     * @return string[]
     */
    public function getSelections(): array
    {
        return [
            'status',
            'accessToken',
            'refreshToken',
        ];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        $query = (new Mutation('authentication'))
            ->setVariables($this->buildVariables())
            ->setSelectionSet(
                [
                    (new Query('login'))
                        ->setArguments($this->buildArguments())
                        ->setSelectionSet($this->getSelections())
                ]
            );

        return $query;
    }

    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return $data['authentication']['login'];
    }
}
