<?php

namespace idoit\Module\SyneticsJdisc\Graphql\Mutation\Discovery;

use GraphQL\Mutation;
use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\SyneticsJdisc\Graphql\AbstractGraphql;
use idoit\Module\SyneticsJdisc\Graphql\ParameterBagInterface;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;
use idoit\Module\SyneticsJdisc\Graphql\Schema\Model\StartJobResultEnum;
use idoit\Module\SyneticsJdisc\Graphql\Type\DiscoveryJobReferenceType;

class StartJob extends AbstractGraphql implements ParameterBagInterface, ResponseInterface
{
    private DiscoveryJobReferenceType $discoveryJobReference;

    /**
     * @param DiscoveryJobReferenceType $discoveryJobReference
     */
    public function setDiscoveryJobReference(DiscoveryJobReferenceType $discoveryJobReference): void
    {
        $this->discoveryJobReference = $discoveryJobReference;
    }

    /**
     * @return array
     */
    public static function getSuccessFlags()
    {
        return [
            StartJobResultEnum::SUCCESS,
            StartJobResultEnum::ALREADY_RUNNING,
        ];
    }

    /**
     * @return array
     */
    public function getSelections(): array
    {
        return [];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        $query = (new Mutation('discovery'))
            ->setVariables($this->buildVariables())
            ->setSelectionSet(
                [
                    (new Query('control'))
                        ->setSelectionSet(
                            [
                                (new Query('startJob'))
                                    ->setArguments($this->buildArguments())
                            ]
                        )
                ]
            );

        return $query;
    }

    /**
     * @return DiscoveryJobReferenceType[]
     */
    public function getParameters() : array
    {
        return [
            $this->discoveryJobReference
        ];
    }

    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return $data['discovery']['control'];
    }
}
