<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type CertificateX509
 * Information about a certificate in the certificate store */
final class CertificateX509Type implements AutoGenerationInterface
{
    /**
     * The certificate alias used in the certificate store
     */
    public ?string $aliasName = null;
    /**
     * The certificate end date
     */
    public $endDate = null;
    /**
     * The certificate extended key usage
     * @var null|iterable|string[]
     */
    public ?iterable $extendedKeyUsage = null;
    /**
     * The certificate issuer
     */
    public ?string $issuer = null;
    /**
     * The certificate public key information
     */
    public ?PublicKeyEncryptionTypeEnum $keyType = null;
    /**
     * The certificate key usage
     * @var null|iterable|CertificateKeyUsageEnum[]
     */
    public ?iterable $keyUsage = null;
    /**
     * The certificate serial number
     */
    public ?string $serialNumber = null;
    /**
     * The certificate signature algorithm
     */
    public ?string $signatureAlgorithm = null;
    /**
     * The certificate start date
     */
    public $startDate = null;
    /**
     * The certificate subject
     */
    public ?string $subject = null;
    /**
     * The certificate subject alternative names
     * @var null|iterable|string[]
     */
    public ?iterable $subjectAlternativeNames = null;
    /**
     * The certificate thumbprint
     */
    public ?string $thumbprint = null;
    /**
     * The certificate version
     */
    public ?string $type = null;
    /**
     * The certificate version
     */
    public ?string $version = null;
    /**
     * A flag whether the certificate is valid or not
     */
    public bool $isValid;
}