<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ClientAccessLicenseInput
 * Client access license (CAL) * @property mixed $creationTime = null The time when the CAL was detected for the first time.
 * @property null|string $description = null The CAL license description
 * @property mixed $expirationDate = null The CAL license expiration date.
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|int $licenseId = null The CAL license id
 * @property null|OperatingSystemInputInputType $operatingSystem = null Gets the operating system for this client access license
 * @property null|ClientAccessLicenseProductTypeEnum $productType = null The CAL product type
 * @property null|ServiceInputInputType $service = null Gets the service for this client access license
 * @property mixed $totalLicenses = null The number of total licenses
 * @property null|ClientAccessLicenseTypeEnum $type = null The CAL license type
 * @property null|string $version = null The CAL version
 */
final class ClientAccessLicenseInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        if ($name === 'productType') {
            return new ClientAccessLicenseProductTypeEnum($value);
        }

        if ($name === 'service') {
            return new ServiceInputInputType($value);
        }

        if ($name === 'type') {
            return new ClientAccessLicenseTypeEnum($value);
        }

        return $value;
    }
}