<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type CyberarkAccountInput
 * The Cyberark secret server account entity. * @property null|string $accountId = null The cyberark account id.
 * @property null|string $address = null The cyberark account address.
 * @property null|bool $automaticManagementEnabled = null The automatic management enabled flag.
 * @property null|string $comment = null The account comment.
 * @property null|CyberarkServerDataInputInputType $cyberarkServer = null The cyberark secret server that this secret belongs to.
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|string $objectName = null The cyberark object name for this account.
 * @property null|string $platformId = null The account cyberark platform id.
 * @property null|string $safeName = null The cyberark safe name for this account.
 * @property null|string $secretType = null The account cyberark secret type.
 * @property null|AccountTypeEnum $type = null The account type.
 * @property null|string $userName = null The cyberark account username.
 * @property null|string $label = null The account label
 * @property null|string $reference = null The account unique reference
 */
final class CyberarkAccountInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'cyberarkServer') {
            return new CyberarkServerDataInputInputType($value);
        }

        if ($name === 'type') {
            return new AccountTypeEnum($value);
        }

        return $value;
    }
}