<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type DeviceDeletionEvent
 * A device deletion event log entry contains meta information whenever a device has been deleted. */
final class DeviceDeletionEventType implements AutoGenerationInterface
{
    /**
     * A comment string entered when deleting devices manually.
     */
    public ?string $comment = null;
    /**
     * The computer name of the device that has been deleted.
     */
    public ?string $computername = null;
    /**
     * The creation timestamp of the event.
     */
    public $creationTime = null;
    /**
     * The operating system family of the device that has been deleted.
     */
    public ?string $deletedBy = null;
    /**
     * The device deletion reason.
     */
    public ?DeviceDeletionReasonEnum $deletionReason = null;
    /**
     * The internal id of the device that has been deleted.
     */
    public $deviceId = null;
    /**
     * The internal id for this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The manufacturer of the device that has been deleted.
     */
    public ?string $manufacturer = null;
    /**
     * The model of the device that has been deleted.
     */
    public ?string $model = null;
    /**
     * The modification timestamp of the event.
     */
    public $modificationTime = null;
    /**
     * The name of the device that has been deleted.
     */
    public ?string $name = null;
    /**
     * The operating system family of the device that has been deleted.
     */
    public ?string $osFamily = null;
    /**
     * The operating system version of the device that has been deleted.
     */
    public ?string $osVersion = null;
    /**
     * The serial number of the device that has been deleted.
     */
    public ?string $serialNumber = null;
    /**
     * The device type of the device that has been deleted.
     */
    public ?DeviceTypeEnum $type = null;
    /**
     * Gets the ip address (v4 or v6) for the device that has been deleted
     */
    public ?string $ipAddress = null;
}