<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type EndOfLifeSupport
 * This object contains information about the EndOfLife.date Support. */
final class EndOfLifeSupportType implements AutoGenerationInterface
{
    /**
     * The date when general active support for this version ends, meaning regular updates and maintenance will no longer be provided after this date.
     */
    public $endOfActiveSupport = null;
    /**
     * The date when general security support for this version ends.
     */
    public $endOfSecuritySupport = null;
    /**
     * The end date for extended support, indicating when any additional, often limited, post-EOL support will no longer be available.
     */
    public $extendedEndOfSupport = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The release date of the latest product version, indicating when the most current version was made publicly available.
     */
    public $latestReleaseDate = null;
    /**
     * The most recent version number available for the product, providing users with the latest stable release information.
     */
    public ?string $latestVersion = null;
    /**
     * A URL linking to more detailed information about the product or specific version, such as official documentation or release notes.
     */
    public ?string $link = null;
    /**
     * Indicates whether this version has Long-Term Support (LTS). For certain versions, this attribute is represented as a Boolean, where true denotes LTS support, while other versions may use a Date to indicate the specific start date of LTS.
     */
    public ?bool $lts = null;
    /**
     * Provides the date of Long-Term Support (LTS) initiation if applicable. When the LTS information is represented as a Date, it specifies the start of the extended support period with stability and security updates.
     */
    public $ltsDate = null;
    /**
     * The version name or codename as specified in endoflife.date, often used in releases to identify versions in addition to version numbers.
     */
    public ?string $name = null;
    /**
     * The name of the product as specified in endoflife.date, identifying the software or OS for which lifecycle information is provided.
     */
    public ?string $productName = null;
    /**
     * The official release date of this version, marking when it was first made available to the public.
     */
    public $release = null;
    /**
     * The version number of the product as specified in endoflife.date, indicating the specific release version.
     */
    public ?string $version = null;
}