<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type InstalledEndpointSecuritySoftwareInput
 * An endpoint security software installed on an operating system. * @property null|bool $antiSpywareEnabled = null A flag whether the endpoint security's anti-spyware is enabled
 * @property mixed $antiSpywareLastUpdated = null The timestamp when the anti-spyware version was last updated
 * @property null|string $antiSpywareVersion = null The anti-spyware version
 * @property null|bool $antivirusEnabled = null A flag whether the endpoint security's antivirus is enabled
 * @property mixed $antivirusLastUpdated = null The timestamp when the antivirus signature was last updated
 * @property null|string $antivirusSignatureVersion = null The antivirus signature version
 * @property null|ApplicationInputInputType $application = null The associated endpoint security application
 * @property null|bool $enabled = null A flag whether the endpoint security is enabled
 * @property null|string $installationPath = null The endpoint security application installation path
 * @property null|bool $nisEnabled = null A flag whether the endpoint NIS is enabled
 * @property null|string $nisEngineVersion = null The antivirus NIS engine version
 * @property mixed $nisSignatureLastUpdated = null The timestamp when the NIS signature was last updated
 * @property null|string $nisSignatureVersion = null The antivirus NIS signature version
 * @property null|OperatingSystemInputInputType $operatingSystem = null The operating system the endpoint security software is installed on
 * @property null|bool $realtimeProtectionEnabled = null A flag whether the endpoint security's realtime protection is enabled
 * @property null|string $uniqueId = null The endpoint security unique id
 * @property null|bool $upToDate = null A flag whether the endpoint security is up-to-date
 */
final class InstalledEndpointSecuritySoftwareInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'application') {
            return new ApplicationInputInputType($value);
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        return $value;
    }
}