<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type KubernetesClusterAccess
 * This object contains information about the Kubernetes Cluster Access information. */
final class KubernetesClusterAccessType implements AutoGenerationInterface
{
    /**
     * A Kubernetes cluster access configuration comment
     */
    public ?string $comment = null;
    /**
     * The Kubernetes config file stored in the password part of the account when a kube.conf file is used
     */
    public ?AccountType $configFile = null;
    /**
     * Is the discovery for this cluster enabled?
     */
    public ?bool $enabled = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The Kubernetes cluster IP or hostname when ServiceAccount token access is used. Otherwise, the server address is part of the .conf file.
     */
    public ?string $ipOrHostname = null;
    /**
     * The Kubernetes cluster access configuration name
     */
    public ?string $name = null;
    /**
     * The Kubernetes cluster TCP/IP port when ServiceAccount token access is used. Otherwise, the port is part of the .conf file.
     */
    public ?int $port = null;
    /**
     * The Kubernetes service account access token when a token based access is used
     */
    public ?AccountType $tokenAccount = null;
}