<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type OperatingSystem
 * The operating system for a specific device. */
final class OperatingSystemType implements AutoGenerationInterface
{
    /**
     * The list of all application instances (e.g. database instances, web server instances, ...).
     * @var null|iterable
     */
    public ?iterable $applicationInstances = null;
    /**
     * Gets the list of client access licenses for this operating system
     * @var null|iterable
     */
    public ?iterable $clientAccessLicenses = null;
    /**
     * The operating system compile time
     */
    public $compileTime = null;
    /**
     * The operating system description
     */
    public ?string $description = null;
    /**
     * The End-of_life support information of the operating system
     */
    public ?EndOfLifeSupportType $endOfLifeSupport = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The operating system's install date
     */
    public $installDate = null;
    /**
     * The list of installed applications.
     * @var null|iterable
     */
    public ?iterable $installedApplications = null;
    /**
     * The list of installed certificates.
     * @var null|iterable
     */
    public ?iterable $installedCertificates = null;
    /**
     * The list of installed endpoint security applications.
     * @var null|iterable
     */
    public ?iterable $installedEndpointSecurityApplications = null;
    /**
     * The list of installed executable files.
     * @var null|iterable
     */
    public ?iterable $installedExecutableFiles = null;
    /**
     * The list of installed patches.
     * @var null|iterable
     */
    public ?iterable $installedPatches = null;
    /**
     * The list of installed services.
     * @var null|iterable
     */
    public ?iterable $installedServices = null;
    /**
     * Gets the list of issued client access licenses for this operating system
     * @var null|iterable
     */
    public ?iterable $issuedClientAccessLicenses = null;
    /**
     * The kernel version
     */
    public ?string $kernelVersion = null;
    /**
     * The operating system's last update time
     */
    public $lastUpdateTime = null;
    /**
     * The operating system's license comment
     */
    public ?string $licenseComment = null;
    /**
     * The operating system's license expiration date
     */
    public $licenseExpirationDate = null;
    /**
     * The operating system's license status
     */
    public ?SoftwareLicenseStatusEnum $licenseStatus = null;
    /**
     * The license type
     */
    public ?LicenseTypeEnum $licenseType = null;
    /**
     * Gets the list of users which belong to this operating system.
     * @var null|iterable
     */
    public ?iterable $localUsers = null;
    /**
     * The locale that is used for this operating system
     */
    public ?string $locale = null;
    /**
     * The locale code that is used for this operating system
     */
    public ?int $localeCode = null;
    /**
     * Gets the list of logged-on users to this operating system
     * @var null|iterable
     */
    public ?iterable $loggedOnUsers = null;
    /**
     * Gets the list of history logged-on users to this operating system
     * @var null|iterable
     */
    public ?iterable $loggedOnUsersHistory = null;
    /**
     * The operating system's manufacturer
     */
    public ?string $manufacturer = null;
    /**
     * The list of all mapped printers.
     * @var null|iterable
     */
    public ?iterable $mappedPrinters = null;
    /**
     * The operating system family (e.g. Windows, Linux, HP-UX, ...)
     */
    public ?string $osFamily = null;
    /**
     * The operating system version (e.g. Windows 10, Windows 2008 Server, ...)
     */
    public ?string $osVersion = null;
    /**
     * The patch level (e.g. Service Pack 3)
     */
    public ?string $owner = null;
    /**
     * The patch level (e.g. Service Pack 3)
     */
    public ?string $patchLevel = null;
    /**
     * The list of pending installations.
     * @var null|iterable
     */
    public ?iterable $pendingUpdates = null;
    /**
     * The list of all processes running on this operating system.
     * @var null|iterable
     */
    public ?iterable $processes = null;
    /**
     * The operating system product key
     */
    public ?string $productKey = null;
    /**
     * The raw version as it gets delivered by the operating system
     */
    public ?string $rawVersion = null;
    /**
     * Is a reboot required to finalize the installation of pending patches?
     */
    public ?bool $rebootRequired = null;
    /**
     * Gets the list of ssh cipher algorithms supported by the operating systems's SSH server
     * @var null|iterable
     */
    public ?iterable $sshCipherAlgorithms = null;
    /**
     * Gets the list of ssh key-exchange algorithms supported by the operating systems's SSH server
     * @var null|iterable
     */
    public ?iterable $sshKeyExchangeAlgorithms = null;
    /**
     * Gets the list of ssh MAC algorithms supported by the operating systems's SSH server
     * @var null|iterable
     */
    public ?iterable $sshMACAlgorithms = null;
    /**
     * The device's system type (e.g. x64, x86, arm, ...)
     */
    public ?string $systemType = null;
    /**
     * The uptime in milliseconds
     */
    public $systemUpTime = null;
    /**
     * The timezone name
     */
    public ?string $timezoneName = null;
    /**
     * The operating system's unique id
     */
    public ?string $uniqueId = null;
    /**
     * The UTC offset for the configured timezone
     */
    public ?int $utcOffset = null;
    /**
     * Finds services by its display name. The display name is the name that is displayed in the services control panel. It can be language dependent.
     * @var null|iterable
     */
    public ?iterable $findInstalledServiceByDisplayName = null;
    /**
     * Finds services by its internal name. The internal name is usually language independent.
     * @var null|iterable
     */
    public ?iterable $findInstalledServiceByInternalName = null;
    /**
     * The list of all application instances (e.g. database instances, web server instances, ...).
     * @var null|iterable
     */
    public ?iterable $applicationInstancesByType = null;
    /**
     * The device that this operating system is installed on.
     */
    public ?DeviceType $device = null;
    /**
     * The list of installed certificates where the issuer matches a regular expression. Refer to the Java regular expression reference documentation on more info on regular expressions
     * @var null|iterable
     */
    public ?iterable $installedCertificatesByIssuerPattern = null;
    /**
     * The list of installed certificates where the issuer matches a regular expression, one of the subject alternative names (SAN) matches a regular expression and the subject matches a regular expression
     * @var null|iterable
     */
    public ?iterable $installedCertificatesByIssuerSANAndSubjectPattern = null;
}