<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ReportMailExportJobInput
 * A report mail export job configuration * @property null|BuiltInReportEnum $builtInReport = null The job's connected report name
 * @property mixed $creationTime = null The entity's creation time.
 * @property mixed $customReportId = null The job's connected custom report id
 * @property null|bool $emptyReport = null The job's export emptyReport attribute
 * @property null|TextFileEncodingEnum $encoding = null The job's export format encoding attribute
 * @property null|bool $encryptZipFile = null The job's export encryptZipFile attribute
 * @property null|string $encryptionPwd = null The job's export encryptionPwd attribute
 * @property null|ExportFormatEnum $exportFormat = null The job's export format
 * @property null|ExportTypeEnum $exportType = null The job's export type
 * @property null|string $fileName = null The job's export format fileName attribute
 * @property null|bool $filterCaseSensitive = null The job's filter case-sensitive flag
 * @property null|string $filterValue = null The job's filter value
 * @property null|string $id = null The internal id of mail export job.
Mandatory for change and delete operations.
Note that the id might change when the entity gets deleted and recreated.
 * @property null|bool $invertFilter = null The job's invert filter flag
 * @property null|MailAccountInputInputType $mailAccount = null The job's export e-mail account id
 * @property null|string $mailMessage = null The job's export mailMessage attribute
 * @property mixed $modificationTime = null The entity's modification time.
 * @property null|string $nullValue = null The default null value sequence
 * @property null|iterable|MailRecipientInputInputType[] $recipients = null The list of mail recipients.
 * @property null|string $reportTitle = null The job's connected report title
 * @property null|string $separator = null The job's export format separator attribute
 * @property null|string $sortByColumn = null The job's sort column configuration
 * @property null|SortOrderEnum $sortOrder = null The job's sort order configuration
 * @property null|string $subjectLine = null The job's export subjectLine attribute
 * @property null|bool $useHumanReadableDateDurationOutput = null The job's export format useHumanReadableDateDurationOutput attribute
 * @property null|bool $useHumanReadableOutput = null The job's export format useHumanReadableOutput attribute
 * @property null|bool $useMultipleLines = null The job's export format useMultipleLines attribute
 * @property null|bool $zipFile = null The job's export zipFile attribute
 * @property null|string $name = null The job's name
 * @property null|ScheduleInputInputType $schedule = null The job's schedule
 * @property mixed $inventoryUserId = null The job's owner id
 * @property null|string $inventoryUserLogin = null The job's owner login
 */
final class ReportMailExportJobInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'builtInReport') {
            return new BuiltInReportEnum($value);
        }

        if ($name === 'encoding') {
            return new TextFileEncodingEnum($value);
        }

        if ($name === 'exportFormat') {
            return new ExportFormatEnum($value);
        }

        if ($name === 'exportType') {
            return new ExportTypeEnum($value);
        }

        if ($name === 'mailAccount') {
            return new MailAccountInputInputType($value);
        }

        if ($name === 'recipients') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new MailRecipientInputInputType($v)); })($value);
        }

        if ($name === 'sortOrder') {
            return new SortOrderEnum($value);
        }

        if ($name === 'schedule') {
            return new ScheduleInputInputType($value);
        }

        return $value;
    }
}