<?php

namespace Axtiva\FlexibleGraphql\Tests\Generator\Model\Psr4;

use Axtiva\FlexibleGraphql\Builder\Foundation\CodeGeneratorBuilder;
use Axtiva\FlexibleGraphql\Generator\Config\Foundation\Psr4\CodeGeneratorConfig;
use Axtiva\FlexibleGraphql\Tests\Helper\FileSystemHelper;
use GraphQL\Language\Parser;
use GraphQL\Type\Definition\Directive;
use GraphQL\Type\Definition\InputObjectType;
use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Schema;
use GraphQL\Utils\BuildSchema;
use PHPUnit\Framework\TestCase;

class ArgsFieldResolverModelGeneratorTest extends TestCase
{
    /**
     * @return void
     * @dataProvider dataProviderGeneratePhpCode
     */
    public function testGeneratePhpCode(
        string $typeName,
        string $fieldName,
        string $languageLevel,
        Schema $schema,
        string $expected
    ) {
        $namespace = 'Axtiva\FlexibleGraphql\Example\GraphQL';
        $dir = uniqid('/tmp/TmpTestData/GraphQL');

        FileSystemHelper::rmdir($dir);
        FileSystemHelper::mkdir($dir);

        $builder = new CodeGeneratorBuilder(new CodeGeneratorConfig($dir, $languageLevel, $namespace));

        $generator = $builder->build();

        /** @var ObjectType $type */
        $type = $schema->getType($typeName);
        $this->assertInstanceOf(ObjectType::class, $type);

        $this->assertNotFalse($type->hasField($fieldName));
        $field = $type->getField($fieldName);

        foreach ($generator->generateFieldResolver($type, $field, $schema) as $item) {
            $code = $item;
        }
        $this->assertTrue(isset($code));
        $this->assertEquals($expected, file_get_contents($code->getFilename()));

        FileSystemHelper::rmdir($dir);
    }

    public function dataProviderGeneratePhpCode(): iterable
    {
        require_once __DIR__ . '/resources/DateTimeScalar.php';
        yield [
            'NamedCurrency',
            'name',
            CodeGeneratorConfig::V7_4,
            BuildSchema::build(Parser::parse(<<<GQL
type NamedCurrency {
    id: ID!
    name(x: Int, testInput: DemoInput!, demo: DemoEnum, date: DateTime, hello: HelloScalar): String!
}
enum DemoEnum {
    A
    B
}
input DemoInput {
  field: Int
}
scalar DateTime
scalar HelloScalar
GQL
            )),<<<'PHP'
<?php

declare (strict_types=1);
namespace Axtiva\FlexibleGraphql\Example\GraphQL\ResolverArgs\NamedCurrency;

use Axtiva\FlexibleGraphql\Type\InputType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\DemoInputInputType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\DemoEnumEnum;
use DateTimeImmutable;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql field args of NamedCurrency.name
 * @property null|int $x = null 
 * @property DemoInputInputType $testInput 
 * @property null|DemoEnumEnum $demo = null 
 * @property null|DateTimeImmutable $date = null 
 * @property mixed $hello = null 
 */
final class NameResolverArgs extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'testInput') {
            return new DemoInputInputType($value);
        }

        if ($name === 'demo') {
            return new DemoEnumEnum($value);
        }

        return $value;
    }
}
PHP
            ,];
        yield [
            'NamedCurrency',
            'name',
            CodeGeneratorConfig::V7_4,
            BuildSchema::build(Parser::parse(<<<GQL
type NamedCurrency {
    id: ID!
    name(x: [[[Int]]], testInput: [[[DemoInput!]!]]!, demo: DemoEnum, date: DateTime, hello: HelloScalar, hello2: [[HelloScalar]]): String!
}
enum DemoEnum {
    A
    B
}
input DemoInput {
  field: Int
}
scalar DateTime
scalar HelloScalar
GQL
            )),<<<'PHP'
<?php

declare (strict_types=1);
namespace Axtiva\FlexibleGraphql\Example\GraphQL\ResolverArgs\NamedCurrency;

use Axtiva\FlexibleGraphql\Type\InputType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\DemoInputInputType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\DemoEnumEnum;
use DateTimeImmutable;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql field args of NamedCurrency.name
 * @property null|iterable|int[][][] $x = null 
 * @property iterable|DemoInputInputType[][][] $testInput 
 * @property null|DemoEnumEnum $demo = null 
 * @property null|DateTimeImmutable $date = null 
 * @property mixed $hello = null 
 * @property null|iterable[] $hello2 = null 
 */
final class NameResolverArgs extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'testInput') {
            return (function($value) {foreach($value as $v) yield (function($value) {foreach($value as $v) yield (function($value) {foreach($value as $v) yield ($v === null ? null : new DemoInputInputType($v)); })($v); })($v); })($value);
        }

        if ($name === 'demo') {
            return new DemoEnumEnum($value);
        }

        return $value;
    }
}
PHP
            ,];
        yield [
            'NamedCurrency',
            'name',
            CodeGeneratorConfig::V7_4,
            BuildSchema::build(Parser::parse(<<<GQL
type NamedCurrency {
    id: ID!
    name(x: [[[Int]]], testInput: [DemoInput!]!, demo: DemoEnum, date: DateTime, hello: HelloScalar, hello2: [[HelloScalar]]): String!
}
enum DemoEnum {
    A
    B
}
input DemoInput {
  field: Int
}
scalar DateTime
scalar HelloScalar
GQL
            )),<<<'PHP'
<?php

declare (strict_types=1);
namespace Axtiva\FlexibleGraphql\Example\GraphQL\ResolverArgs\NamedCurrency;

use Axtiva\FlexibleGraphql\Type\InputType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\DemoInputInputType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\DemoEnumEnum;
use DateTimeImmutable;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql field args of NamedCurrency.name
 * @property null|iterable|int[][][] $x = null 
 * @property iterable|DemoInputInputType[] $testInput 
 * @property null|DemoEnumEnum $demo = null 
 * @property null|DateTimeImmutable $date = null 
 * @property mixed $hello = null 
 * @property null|iterable[] $hello2 = null 
 */
final class NameResolverArgs extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'testInput') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DemoInputInputType($v)); })($value);
        }

        if ($name === 'demo') {
            return new DemoEnumEnum($value);
        }

        return $value;
    }
}
PHP
            ,];
    }
}