<?php

namespace idoit\Module\SyneticsFlows;

use Exception;
use isys_application;
use isys_auth;
use isys_auth_dao;
use isys_auth_interface;
use isys_auth_rights_map_interface;
use isys_exception_auth;

class Auth extends isys_auth implements isys_auth_interface, isys_auth_rights_map_interface
{
    /**
     * Container for singleton instance.
     *
     * @var  Auth
     */
    private static $m_instance;

    /**
     * Retrieve singleton instance of authorization class.
     *
     * @return  self
     */
    public static function instance()
    {

        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$m_instance === null) {
            self::$m_instance = new self;
        }

        return self::$m_instance;
    }

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     */
    public function get_auth_methods()
    {
        return [
            'manage-flows' => [
                'title'   => 'LC__MODULE__SYNETICS_FLOWS__MANAGE_FLOWS',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::CREATE, isys_auth::EDIT, isys_auth::DELETE, isys_auth::SUPERVISOR],
                'default' => [isys_auth::VIEW],
            ],
        ];
    }

    /**
     * Get ID of related module.
     *
     * @return  integer
     */
    public function get_module_id()
    {
        return defined_or_default('C__MODULE__SYNETICS_FLOWS');
    }

    /**
     * Get title of related module.
     *
     * @return  string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__SYNETICS_FLOWS__FLOWS';
    }

    /**
     * Method for checking, if the user is allowed to manage the flows.
     *
     * @param   integer $right
     *
     * @return  boolean
     *
     * @throws  isys_exception_auth
     * @throws  Exception
     */
    public function manageFlows($right)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_right(
            $right,
            'manage-flows',
            self::EMPTY_ID_PARAM,
            new isys_exception_auth(isys_application::instance()->container->get('language')->get('You are not allowed to manage flows.'))
        );
    }

    /**
     * @param $right
     *
     * @return bool
     */
    public function hasRight($right): bool
    {
        try {
            return $this->manageFlows($right);
        } catch (\Throwable) {
            return false;
        }
    }

    /**
     * @return array
     */
    public function getRightsMap(): array
    {
        return [
            isys_auth::CREATE => [isys_auth::VIEW],
            isys_auth::VIEW => [],
            isys_auth::EDIT => [isys_auth::VIEW],
            isys_auth::ARCHIVE => [],
            isys_auth::DELETE => [isys_auth::VIEW],
            isys_auth::EXECUTE => [],
            isys_auth::SUPERVISOR => [isys_auth::VIEW, isys_auth::CREATE, isys_auth::EDIT, isys_auth::DELETE],
        ];
    }
}
