<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Argument;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;

class StringArgumentConverter implements ArgumentConverter
{

    public function convert(Command $command, InputArgument $argument): ?IdoitCliArgument
    {
        $default = $argument->getDefault();
        return new StringArgument($argument->getName(), $argument->getDescription(), $argument->isRequired(), is_string($default) ? $default : null);
    }

    public function supports(Command $command, InputArgument $argument): bool
    {
        return !$argument->isArray();
    }
}