<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Command;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\IdoitCommand;
use Symfony\Component\Console\Command\Command;

class CollectionConverter implements CommandConverter
{
    public function __construct(private array $converters)
    {
    }

    public function convert(Command $command): ?IdoitCommand
    {
        foreach ($this->converters as $converter) {
            if ($converter->supports($command)) {
                return $converter->convert($command);
            }
        }

        return null;
    }

    public function supports(Command $command): bool
    {
        foreach ($this->converters as $converter) {
            if ($converter->supports($command)) {
                return true;
            }
        }

        return false;
    }
}