<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputOption;

class StringArrayOptionConverter implements OptionConverter
{
    public function convert(Command $command, InputOption $option): ?IdoitCliOption
    {
        $default = $option->getDefault();
        return new StringArrayOption($option->getName(), $option->getDescription(), $option->isValueRequired(), is_array($default) ? $default : null);
    }

    public function supports(Command $command, InputOption $option): bool
    {
        return $option->acceptValue() && $option->isArray();
    }
}