<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CmdbScope;
use idoit\Module\SyneticsFlows\Validation\Required;

class RankObjectAction extends ActionType
{
    public const STATUS_NEXT = "next";

    public function __construct(
        #[Required]
        private ?CmdbScope $scope = null,
        #[Required]
        private string $status = self::STATUS_NEXT,
    )
    {
    }

    public function getScope(): ?CmdbScope
    {
        return $this->scope;
    }

    public function getStatus(): string
    {
        return $this->status;
    }
}
