<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CategoryChange;
use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Validation\Required;

class CreateObjectInfo extends ExecutionInfo
{
    public function __construct(
        #[Required]
        private ?int $objectTypeId = null,
        #[Required]
        private ?string $title = null,
        #[ArrayFormat(CategoryChange::class)]
        private array $changes = [],
    )
    {
    }

    public function getObjectTypeId(): ?int
    {
        return $this->objectTypeId;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @return CategoryChange[]
     */
    public function getChanges(): array
    {
        return $this->changes;
    }

    public function __toString(): string
    {
        return 'Create object "' . $this->title . '" of object type ' . $this->objectTypeId;
    }
}
