<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo;

use idoit\Module\SyneticsFlows\Validation\Required;

class RankObjectInfo extends ExecutionInfo
{
    public function __construct(
        #[Required]
        private string $status,
        #[Required]
        private array $objectIds = [],
    )
    {
    }

    /**
     * @return array|null
     */
    public function getObjectIds(): ?array
    {
        return $this->objectIds;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    public function __toString(): string
    {
        $count = count($this->objectIds);

        if ($count === 1) {
            return 'Rank object';
        }
        return "Rank $count objects";
    }
}
