<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

use DateTime;

class ObjectCategoryContext extends ObjectContext
{
    public function __construct(
        string $objectId,
        string $objectType,
        private string $category,
        ?string $userId = null,
        ?DateTime $time = null
    )
    {
        parent::__construct($objectId, $objectType, $userId, $time);
    }

    public function getCategory(): string
    {
        return $this->category;
    }
}