<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\ConnectSignal;

use idoit\Component\Helper\ArrayHelper;
use idoit\Context\Context;

class Connect
{
    public function __construct(private \isys_component_signalcollection $signalcollection)
    {
    }

    public function add(string $signal, $service): void
    {
        $this->signalcollection->connect($signal, function (...$args) use ($signal, $service) {
            $service($signal, ...$args);
        });
    }

    public static function getBlockedStates()
    {
        return [
            C__RECORD_STATUS__BIRTH,
            C__RECORD_STATUS__TEMPLATE,
            C__RECORD_STATUS__MASS_CHANGES_TEMPLATE
        ];
    }

    public static function getAllowedContextCustomers()
    {
        return [
            Context::CONTEXT_TEMPLATE,
            Context::CONTEXT_DUPLICATE,
            Context::CONTEXT_MASS_CHANGE,
            Context::CONTEXT_MULTIEDIT,
        ];
    }

    public static function supportsContext(?array $additionalContext = [])
    {
        $context = Context::instance();
        if (!in_array($context->getContextCustomer(), ArrayHelper::concat(Connect::getAllowedContextCustomers(), $additionalContext))) {
            return false;
        }

        return true;
    }
}
