<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Filter;

use idoit\Module\SyneticsFlows\Dto\Criteria;
use idoit\Module\SyneticsFlows\Serialization\StringArrayFormat;

class CiObjectFilter
{
    public function __construct(
        #[StringArrayFormat]
        private array $types = [],
        #[StringArrayFormat]
        private array $ids = [],
        private ?string $title = '',
        private ?Criteria $criteria = null,
        #[StringArrayFormat]
        private array $statuses = ["2"],
    )
    {
    }

    public function getTypes(): array
    {
        return $this->types;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function getIds(): array
    {
        return $this->ids;
    }
    public function getCriteria(): ?Criteria
    {
        return $this->criteria;
    }

    public function getStatuses(): array
    {
        return $this->statuses;
    }
}
