<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Validation;

use Attribute;

#[Attribute(Attribute::TARGET_PROPERTY)]
class Required extends Validator
{
    public const DEFAULT_MESSAGE = 'LC__MODULE__SYNETICS_FLOWS__VALUE_REQUIRED';

    public function __construct(private ?string $errorMessage = null)
    {
    }

    public function validate(mixed $value): array
    {
        if (is_string($value) && strlen($value) > 0) {
            return [];
        }

        if (empty($value)) {
            return [$this->errorMessage ?? self::DEFAULT_MESSAGE];
        }
        return [];
    }
}
