<?php

namespace idoit\Module\SyneticsJdisc\Graphql\Query\Device;

use GraphQL\Query;
use idoit\Module\SyneticsJdisc\Graphql\Query\GetDiscoveryLog;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;
use idoit\Module\SyneticsJdisc\Graphql\Schema\Model\DiscoveryStatusAreaEnum;

class GetDiscoverDeviceLog extends GetDiscoveryLog implements ResponseInterface
{
    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        $query = (new Query('status'))
            ->setSelectionSet([
                (new Query('discovery'))
                    ->setSelectionSet([
                        (new Query('status'))
                            ->setArguments(['statusArea' => new DiscoveryStatusAreaEnum('Devices')])
                            ->setSelectionSet([
                                (new Query('deviceQueueStatus'))
                                    ->setSelectionSet([
                                        'lastAction',
                                        (new Query('devices'))
                                            ->setSelectionSet(['target', 'lastLog'])
                                    ])
                            ])
                    ])
            ]);
        return $query;
    }
}
