<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type CyberarkServerData
 * This object contains information about the cyberark secret server. */
final class CyberarkServerDataType implements AutoGenerationInterface, PasswordManagerServerInterface
{
    /**
     * The application id
     */
    public ?string $appId = null;
    /**
     * The authentication type
     */
    public ?CyberarkAuthenticationTypeEnum $authType = null;
    /**
     * The CCP server address (IP address or hostname). When null, it uses the same as the PVWA server config
     */
    public ?string $ccpServerAddress = null;
    /**
     * The CCP server port that the CCP server is listening on. (Uses the PVWA settings when null)
     */
    public ?int $ccpServerPort = null;
    /**
     * The client certificate bytes
     * @var null|iterable|int[]
     */
    public ?iterable $certificateBytes = null;
    /**
     * The Client Certificate password, if any
     */
    public ?string $clientCertificatePassword = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The server's descriptive name as provided by the user.
     */
    public ?string $name = null;
    /**
     * The object name
     */
    public ?string $objectName = null;
    /**
     * The password used to authenticate against the Cyberark server..
     */
    public ?string $password = null;
    /**
     * The PVWA server address (IP address or hostname).
     */
    public ?string $pvwaServerAddress = null;
    /**
     * The port that the PVWA server is listening on.
     */
    public ?int $pvwaServerPort = null;
    /**
     * The safe name
     */
    public ?string $safeName = null;
    /**
     * The server status
     */
    public ?PasswordManagementStatusType $status = null;
    /**
     * A flag whether the API should use a proxy or not
     */
    public ?bool $useProxy = null;
    /**
     * The username used to authenticate against the Cyberark server..
     */
    public ?string $username = null;
    /**
     * The server label
     */
    public ?string $label = null;
}