<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DiscoverySettingsInput
 * Discovery settings input * @property null|bool $addManagedPhysicalServers = null flag to add virtualization physical server
 * @property null|bool $addVirtualMachines = null flag to add virtualization machines
 * @property null|bool $addVirtualizationManagementServer = null flag to add virtualization management server
 * @property null|bool $ageOutLastLoggedOnUsersEnabled = null flag to delete users from logged on user history after specific time
 * @property mixed $agingOutDeviceDeletionLogsInMinutes = null Aging out deletion logs in minutes
 * @property null|bool $agingOutDeviceEventsEnabled = null flag to age out device events
 * @property null|int $agingOutDeviceEventsInDays = null Last Days to Collect Device Events
 * @property null|bool $agingOutDevicesEnabled = null Aging out devices flag
 * @property null|bool $agingOutDiscoveryEventsEnabled = null Aging out discovery events flag
 * @property mixed $agingOutDiscoveryEventsInMinutes = null Aging out discovery events in minutes
 * @property mixed $agingOutInMinutes = null Aging out devices in minutes
 * @property null|bool $arpCacheReadingEnabled = null flag to discover devices found in ARP caches of routers and switches
 * @property null|bool $arpProxyEnabled = null flag to enable remote jumphost
 * @property null|int $arpProxyMaxSubnetCandidates = null Max count of server/client jumphost connection attempts per IP subnet
 * @property null|bool $arpSNMPRouterEnabled = null flag to enable SNMP ARP table reading on routers and routing switches
 * @property null|bool $createNewDevicesForRemoteConnectionClients = null flag to create new devices for user connections from remote devices
 * @property mixed $db2JdbcConnectTimeout = null Ibm DB2 database connect timeout in milliseconds
 * @property null|bool $deleteOrphanedSoftwareElements = null flag to delete orphaned software that no longer belongs to any devices
 * @property null|bool $dependencyMappingAgingOutEnabled = null flag to delete inactive dependencies between computers after specific time
 * @property null|int $dependencyMappingAgingSeconds = null Seconds after which inactive dependencies between computers are deleted
 * @property null|DeviceNamingMethodEnum $deviceNamingMethod = null Device Naming Method
 * @property null|DeviceNamingStrategyEnum $deviceNamingStrategy = null Device Naming Strategy
 * @property null|bool $discoverAnonymousWlans = null flag to discover anonymous Wlans (without SSID)
 * @property null|bool $discoverAntivirusSoftware = null flag to discover antivirus software
 * @property null|bool $discoverApplications = null flag to discover applications
 * @property null|bool $discoverBladeEnclosureComponents = null flag to discover remote clients
 * @property null|bool $discoverCertificates = null flag to discover certificates
 * @property null|bool $discoverCertificatesWebSites = null flag to discover https certificates
 * @property null|bool $discoverCiscoSupportEntitlements = null flag to Discover Cisco Support Entitlements
 * @property null|bool $discoverClientAccessLicenses = null flag to discover client access licenses
 * @property null|bool $discoverCloudUsers = null flag to Discover Cloud Users
 * @property null|bool $discoverClusterConfiguration = null flag to discover cluster
 * @property null|bool $discoverContainer = null flag to discover containers
 * @property null|bool $discoverCustomAttributes = null flag to discover custom attributes
 * @property null|bool $discoverDatabaseSchemas = null flag to discover schemas within databases
 * @property null|bool $discoverDatabaseTables = null flag to discover tables within schemas of databases
 * @property null|bool $discoverDatabases = null flag to discover database details
 * @property null|bool $discoverDellSupportEntitlements = null flag to Discover Dell Support Entitlements
 * @property null|bool $discoverDirectXVersion = null flag to discover Direct X version
 * @property null|bool $discoverDirectlyAttachedDevices = null flag to discover attached devices
 * @property null|bool $discoverDisks = null flag to discover disks
 * @property null|bool $discoverDnsDomainControllers = null Flag to Discover Dns Domain Controllers
 * @property null|bool $discoverDnsServers = null Flag to discover Dns Servers
 * @property null|bool $discoverDrivers = null flag to discover drivers
 * @property null|bool $discoverExchangeServerMailboxes = null flag to discover exchange server mailboxes
 * @property null|bool $discoverExeFiles = null flag to discover exe files
 * @property null|bool $discoverFirewallConfiguration = null flag to discover firewall configuration
 * @property null|bool $discoverFujitsuSupportEntitlements = null flag to Discover Fujitsu Support Entitlements
 * @property null|bool $discoverICSIConfiguration = null flag to discover ISCSI initiators and targets
 * @property null|bool $discoverLenovoSupportEntitlements = null flag to Discover Lenovo Support Entitlements
 * @property null|bool $discoverLexmarkSupportEntitlements = null flag to Discover Lexmark Support Entitlements
 * @property null|bool $discoverLicenses = null flag to discover licenses
 * @property null|bool $discoverLocalCardReaders = null flag to discover card readers
 * @property null|bool $discoverLocalPrinters = null flag to discover local printers
 * @property null|bool $discoverLocalScanners = null flag to discover local scanners
 * @property null|bool $discoverManagedDevices = null flag to discover managed devices
 * @property null|bool $discoverMappedPrinters = null flag to discover mapped printers
 * @property null|bool $discoverMemoryModules = null flag to discover memory modules
 * @property null|bool $discoverMonitors = null flag to discover monitors
 * @property null|bool $discoverMotionEvents = null flag to discover motion events
 * @property null|bool $discoverOfflineVirtualInstances = null flag to discover offline virtual instances
 * @property null|bool $discoverOracleLMSConfiguration = null flag to run Oracle LMS scripts
 * @property null|bool $discoverPatches = null flag to discover patches
 * @property null|bool $discoverPendingInstallations = null flag to discover pending installations
 * @property null|bool $discoverProcessLoadedModules = null flag to discover process loaded modules
 * @property null|bool $discoverProcesses = null flag to discover processes
 * @property null|bool $discoverProcessors = null flag to discover processors
 * @property null|bool $discoverReachableWlans = null flag to discover reachable WLANs
 * @property null|bool $discoverRebootEvents = null flag to discover reboot, shutdown and bluescreen events
 * @property null|bool $discoverRemoteConnectionClients = null flag to discover remote clients
 * @property null|bool $discoverScheduledTasks = null flag to discover scheduled tasks
 * @property null|bool $discoverServices = null flag to discover services
 * @property null|bool $discoverShares = null flag to discover shares
 * @property null|bool $discoverSimCards = null flag to discover sim cards
 * @property null|bool $discoverSoundDevices = null flag to discover sound devices
 * @property null|bool $discoverSslConfig = null flag to scan SSL configuration
 * @property null|int $discoverSupportEntitlementEveryNDays = null Collecting support entitlements time interval
 * @property null|bool $discoverSupportEntitlements = null flag to Discover Support Entitlements
 * @property null|bool $discoverSwidtagFiles = null flag to discover Swidtag Files
 * @property null|bool $discoverToshibaSupportEntitlements = null flag to Discover Tochiba Support Entitlements
 * @property null|bool $discoverTpmModule = null flag to discover Tpm modules
 * @property null|bool $discoverUserGroups = null flag to Discover User Groups
 * @property null|bool $discoverUsers = null flag to Discover Users
 * @property null|bool $discoverVMSnasphots = null flag to discover snapshots
 * @property null|bool $discoverVMwareCustomAttributes = null flag to discover VMware annotations
 * @property null|bool $discoverVideoControllers = null flag to discover video controllers
 * @property null|bool $discoverVirtualInstances = null flag to discover virtual instances
 * @property null|bool $discoverWindowsFeatures = null flag to discover windows features
 * @property null|bool $discoverWlanAccessPoints = null flag to discover Wlan Access Points
 * @property null|bool $discoverWlans = null flag to discover Wlans
 * @property null|bool $discoverXeroxSupportEntitlements = null flag to Discover Xerox Support Entitlements
 * @property null|bool $discoverZebraSupportEntitlements = null flag to Discover Zebra Support Entitlements
 * @property null|int $endOfLifeHttpsConnectTimeout = null Https connection for EoL data timeout in milliseconds
 * @property null|int $endOfLifeHttpsReadTimeout = null Https read of EoL data timeout in milliseconds
 * @property null|bool $endOfLifeSupportEnabled = null flag to discover support End of Life information
 * @property null|int $endOfLifeUpdateIntervalInDays = null Days interval to update end of life data
 * @property mixed $exchangePowershellScriptExecuteTimeout = null Powershell execution timeout in milliseconds (to discover exchange server mailboxes)
 * @property null|bool $findRemoteClientConnections = null flag to detect remote connections via RDP, SSH or telnet
 * @property mixed $informixJdbcConnectTimeout = null Informix database connect timeout in milliseconds
 * @property null|bool $javaLicensingCheck = null flag to check Java licensing
 * @property null|bool $keepDiscoverMonitors = null flag to keep disconnected monitors
 * @property null|int $killInactiveDevicesAfterSeconds = null Kill Inactive Device After Seconds
 * @property null|int $lastLoggedOnUsersAgeOutHours = null Hours after which logged on users history is deleted
 * @property mixed $maxDbJdbcConnectTimeout = null SAP MaxDB database connect timeout in milliseconds
 * @property null|int $maxPingThreads = null Max Ping Threads
 * @property null|int $maxThreads = null Max Threads
 * @property mixed $mongoDbJdbcConnectTimeout = null MongoDB database connect timeout in milliseconds
 * @property null|int $motionEventsHistorySinceDays = null Last days to collect motion events
 * @property mixed $mssqlServerDbJdbcConnectTimeout = null MS SQLServer database connect timeout in milliseconds
 * @property mixed $mySqlJdbcConnectTimeout = null MySQL/MariaDB database connect timeout in milliseconds
 * @property null|NetworkCreationPolicyEnum $networkCreationPolicy = null Network Creation Policy
 * @property mixed $oracleDbJdbcConnectTimeout = null Oracle database connect timeout in milliseconds
 * @property null|string $oracleLmsZipFile = null The location of oracle LMS zip file on discovery server
 * @property null|bool $policyDoNotDiscoverAttachedDevicesWhenConnectedToVpn = null flag to ignore directly attached devices when connected via VPN
 * @property null|bool $policyDoNotDiscoverMdnsUpnpDevicesWhenConnectedToVpn = null flag to ignore mDNS and UPnP enabled devices when connected via VPN
 * @property null|bool $policyDoNotDiscoverWlansWhenConnectedToVpn = null flag to ignore WLANs when connected via VPN
 * @property mixed $postgresDbJdbcConnectTimeout = null Postgres database connect timeout in milliseconds
 * @property null|bool $purgeOldMotionEvents = null flag to purge older motion events
 * @property null|bool $scanSshAlgorithmsEnabled = null flag to discover ssh security algorithms
 * @property mixed $sybaseJdbcConnectTimeout = null Sybase database connect timeout in milliseconds
 * @property null|bool $trackDeviceDeletion = null Track device deletion flag
 * @property null|bool $useHostnameOnlyForName = null Use hostname only for name flag
 * @property null|VLanIdentificationMethodEnum $vlanIdentification = null Method to identify Vlans
 * @property null|iterable|WlanWhitelistPatternEntryInputInputType[] $wlanWhitelistPatterns = null The list of WLAN white list patterns
 */
final class DiscoverySettingsInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'deviceNamingMethod') {
            return new DeviceNamingMethodEnum($value);
        }

        if ($name === 'deviceNamingStrategy') {
            return new DeviceNamingStrategyEnum($value);
        }

        if ($name === 'networkCreationPolicy') {
            return new NetworkCreationPolicyEnum($value);
        }

        if ($name === 'vlanIdentification') {
            return new VLanIdentificationMethodEnum($value);
        }

        if ($name === 'wlanWhitelistPatterns') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new WlanWhitelistPatternEntryInputInputType($v)); })($value);
        }

        return $value;
    }
}