<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type LogicalDiskInput
 * A logical disk drive. * @property null|DiskEncryptionAlgorithmEnum $encryptionAlgorithm = null The logical disk encryption algorithm.
 * @property null|DiskEncryptionMethodEnum $encryptionMethod = null The logical disk encryption method.
 * @property null|string $fileSystem = null The logical disk filesystem type.
 * @property mixed $freeSpace = null The free space on this logical disk in KB.
 * @property null|string $location = null The logical disk location. The location might be in a remote disk array.
 * @property null|string $mountPoint = null The logical disk mount point.
 * @property null|string $name = null The logical disk name.
 * @property mixed $provisionedSize = null A logical disk's provisioned size in KB.
 * @property null|string $serialNumber = null A logical disk's serial number.
 * @property mixed $totalSize = null A logical disk's total size in KB.
 * @property mixed $usedSpace = null The used space on this logical disk in KB.
 */
final class LogicalDiskInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'encryptionAlgorithm') {
            return new DiskEncryptionAlgorithmEnum($value);
        }

        if ($name === 'encryptionMethod') {
            return new DiskEncryptionMethodEnum($value);
        }

        return $value;
    }
}