<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsJdisc\Model\Dto;

use Idoit\Dto\Serialization\ReadonlyFormat;
use Idoit\Dto\Serialization\SerializableTrait;
use Idoit\Dto\Validation\Required;
use idoit\Module\SyneticsJdisc\Model\Dto\ConfServer;
use JsonSerializable;

class SyncProfile implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id = '',
        #[Required]
        private ?string $name = '',
        private ?string $description = '',
        private ?array $categories = null,
        private ?int $import_all_software = 0,
        private ?int $import_software_licences = 0,
        private ?int $import_software_services = 0,
        private ?int $import_all_networks = 0,
        private ?int $import_all_clusters = 0,
        private ?int $import_all_blade_connections = 0,
        private ?array  $jdisc_server = null,
        private ?int $import_custom_attributes = 0,
        private ?int $import_all_vlans = 0,
        private ?string $import_type_interfaces = '',
        private ?array $cmdb_status = null,
        private ?int $use_default_templates = 0,
        private ?array $software_filter = null,
        private ?int $software_obj_title = 0,
        private ?int $update_objtype = 0,
        private ?int $update_obj_title = 0,
        private ?int $chassis_module_update_objtype = 0,
        private ?int $use_simple_database_mod = 0,
        private ?array $network_adresses = null,
        private ?int $import_type_dhcp_addresses = 0,
        private ?int $import_cloud_subscriptions = 0,
        private ?int $import_connection_endpoint = 0,
        private ?int $import_create_cloud_users = 0,
        private ?int $adopt_location = 0,
        private ?string $last_scanned_device = '',
        private ?int $resolve_fqdn = 0,
        private ?array $network_import_filter = null,
        private ?array  $mac_filter = null,
        private ?array $software_location = null,
        private ?array $network_location = null,
        private ?array $cmdb_status_created = null,
        private ?array $chassis_assigned_modules_objtype = null,
        private ?array $type_map = null,
        private ?array $column_settings = null,
        private ?ConfServer $conf_server = null,
        #[ReadonlyFormat]
        private ?string $lastSync = null
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getCategories(): ?array
    {
        return $this->categories;
    }

    public function getImportAllSoftware(): ?int
    {
        return $this->import_all_software;
    }

    public function getImportSoftwareLicences(): ?int
    {
        return $this->import_software_licences;
    }

    public function getImportSoftwareServices(): ?int
    {
        return $this->import_software_services;
    }

    public function getImportAllNetworks(): ?int
    {
        return $this->import_all_networks;
    }

    public function getImportAllClusters(): ?int
    {
        return $this->import_all_clusters;
    }

    public function getImportAllBladeConnections(): ?int
    {
        return $this->import_all_blade_connections;
    }

    public function getJdiscServer(): ?array
    {
        return $this->jdisc_server;
    }

    public function getImportCustomAttributes(): ?int
    {
        return $this->import_custom_attributes;
    }

    public function getImportAllVlans(): ?int
    {
        return $this->import_all_vlans;
    }

    public function getImportTypeInterfaces(): ?string
    {
        return $this->import_type_interfaces;
    }

    public function getCmdbStatus(): ?array
    {
        return $this->cmdb_status;
    }

    public function getUseDefaultTemplates(): ?int
    {
        return $this->use_default_templates;
    }

    public function getSoftwareFilter(): ?array
    {
        return $this->software_filter;
    }


    public function getSoftwareObjTitle(): ?int
    {
        return $this->software_obj_title;
    }

    public function getUpdateObjtype(): ?int
    {
        return $this->update_objtype;
    }

    public function getUpdateObjTitle(): ?int
    {
        return $this->update_obj_title;
    }

    public function getChassisModuleUpdateObjtype(): ?int
    {
        return $this->chassis_module_update_objtype;
    }

    public function getUseSimpleDatabaseMod(): ?int
    {
        return $this->use_simple_database_mod;
    }

    public function getNetworkAdresses(): ?array
    {
        return $this->network_adresses;
    }

    public function getImportTypeDhcpAddresses(): ?int
    {
        return $this->import_type_dhcp_addresses;
    }

    public function getImportCloudSubscriptions(): ?int
    {
        return $this->import_cloud_subscriptions;
    }

    public function getImportConnectionEndpoint(): ?int
    {
        return $this->import_connection_endpoint;
    }

    public function getImportCreateCloudUsers(): ?int
    {
        return $this->import_create_cloud_users;
    }

    public function getAdoptLocation(): ?int
    {
        return $this->adopt_location;
    }

    public function getLastScannedDevice(): ?string
    {
        return $this->last_scanned_device;
    }

    public function getResolveFqdn(): ?int
    {
        return $this->resolve_fqdn;
    }

    public function getNetworkImportFilter(): ?array
    {
        return $this->network_import_filter;
    }

    public function getMacFilter(): ?array
    {
        return $this->mac_filter;
    }

    public function getSoftwareLocation(): ?array
    {
        return $this->software_location;
    }

    public function getNetworkLocation(): ?array
    {
        return $this->network_location;
    }

    public function getCmdbStatusCreated(): ?array
    {
        return $this->cmdb_status_created;
    }

    public function getLastSync(): ?string
    {
        return $this->lastSync;
    }

    public function getChassisAssignedModulesObjtype(): ?array
    {
        return $this->chassis_assigned_modules_objtype;
    }

    public function getTypeMap(): ?array
    {
        return $this->type_map;
    }

    public function getColumnSettings(): ?array
    {
        return $this->column_settings;
    }

    public function getConfServer(): ?ConfServer
    {
        return $this->conf_server;
    }

    /**
     * @param array|null $type_map
     * @return SyncProfile
     */
    public function setTypeMap(?array $type_map): self
    {
        $this->type_map = $type_map;
        return $this;
    }

    public function setLastSync(?string $lastSync): self
    {
        $this->lastSync = $lastSync;
        return $this;
    }
}
